 /****************************************************************
 *		t1pwm_clk.c   -  clock generator
 *
 *	This generates a 500khz clock that was required by a SC filter 
 *	used on one test board. This is not needed for most applications.
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 ****************************************************************/
#include "LPC17xx.h"


#define TCR_CNT_EN		0x00000001
#define TCR_RESET		0x00000002


void InitT1PWM(void)
{
	TIM1->TCR = TCR_RESET;	// Counter Reset // 
	TIM1->MCR = 0x02;			// Set MRO to reset on Match
	TIM1->MR0 = 11;				// toggle frequency = 12Mhz/2*(T1MR0+1) = 500 khz 
							// (for SC filter clock)
	TIM1->EMR = 0x31;			// Toggle MR0 on match (pin 51 on LPC2378)
	TIM1->TCR = TCR_CNT_EN;		// Enable counter 	
}


